/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.mixin.accessor.ItemEntityAccessor;
import svenhjol.charm.module.NetheriteNuggets;

@Module(mod="charm", description="Extends the lifetime of netherite-based items before they despawn.", hasSubscriptions=true)
public class ExtendNetherite
extends CharmModule {
    @Config(name="Extra lifetime", description="Additional time (in seconds) given to netherite and netherite-based items before they despawn.")
    public static int extendBy = 300;
    public static List<Item> netheriteItems = new ArrayList<Item>();
    private static ItemStack lastTossedStack = null;
    private static long lastTossedTime = 0L;

    @Override
    public void init() {
        netheriteItems = Arrays.asList(Items.field_234757_kL_, Items.field_234794_rw_, Items.field_234766_lv_, Items.field_234764_lt_, Items.field_234763_ls_, Items.field_234758_kU_, Items.field_234759_km_, Items.field_234765_lu_, Items.field_234756_kK_, Items.field_234760_kn_, Items.field_234755_kJ_, Items.field_234754_kI_, NetheriteNuggets.NETHERITE_NUGGET);
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        World world = event.getEntity().func_130014_f_();
        if (!world.field_72995_K) {
            lastTossedStack = event.getEntityItem().func_92059_d();
            lastTossedTime = world.func_82737_E();
        }
    }

    @SubscribeEvent
    public void onItemExpire(ItemExpireEvent event) {
        if (!event.isCanceled()) {
            World world = event.getEntity().func_130014_f_();
            if (world.field_72995_K) {
                return;
            }
            ItemStack stack = event.getEntityItem().func_92059_d();
            long gameTime = world.func_82737_E();
            long existedTicks = gameTime - lastTossedTime;
            if (lastTossedStack != null && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)lastTossedStack) && existedTicks >= 0L && existedTicks < 5L) {
                lastTossedStack = null;
                lastTossedTime = 0L;
                return;
            }
            int age = ((ItemEntityAccessor)event.getEntityItem()).getAge();
            if (netheriteItems.contains(stack.func_77973_b()) && age <= 6020) {
                event.setExtraLife(extendBy * 20);
                event.setCanceled(true);
            }
        }
    }
}

